import pandas as pd  
import pickle 
from decision_company import read_csv_file, avg, series_value_counts, series_to_dict
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Define the target customer segments  
target_customer_segments = [1, 2]  # Replace this list with the target customer segments from the previous step  
  
# Summarize the key characteristics of each target customer segment  
summary = {}  
for segment in target_customer_segments:  
    segment_customers = credit_customers[credit_customers['cluster'] == segment]  
    summary[segment] = {  
        'average_age': avg(segment_customers['age']),  
        'average_credit_amount': avg(segment_customers['credit_amount']),  
        'employment_distribution': series_to_dict(series_value_counts(segment_customers['employment'], normalize=True)),  
        'savings_status_distribution': series_to_dict(series_value_counts(segment_customers['savings_status'], normalize=True)),  
        'credit_history_distribution': series_to_dict(series_value_counts(segment_customers['credit_history'], normalize=True))  
    }  
  
print("summary:\n", summary)    
pickle.dump(summary,open("./ref_result/summary.pkl","wb"))